#include "editorview.h"

// ----------------------------------------------------------------------------------------------------------------------------

CString ErrorLog, ModuleDirectory;

// ----------------------------------------------------------------------------------------------------------------------------

void GetModuleDirectory()
{
	char *moduledirectory = new char[256];
	GetModuleFileName(GetModuleHandle(NULL), moduledirectory, 256);
	*(strrchr(moduledirectory, '\\') + 1) = 0;
	ModuleDirectory = moduledirectory;
	delete [] moduledirectory;
}

// ----------------------------------------------------------------------------------------------------------------------------

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR sCmdLine, int iShow)
{
	GetModuleDirectory();

	InitCommonControls();

	CEditorView *EditorView = new CEditorView();

	if(EditorView != NULL)
	{
		char *AppName = "3D game editor";

		if(EditorView->Init(hInstance, AppName, 800, 600))
		{
			EditorView->Show(true);

			MSG Msg;

			while(GetMessage(&Msg, NULL, 0, 0) > 0)
			{
				TranslateMessage(&Msg);
				DispatchMessage(&Msg);
			}
		}
		else
		{
			MessageBox(NULL, ErrorLog, AppName, MB_OK | MB_ICONERROR);
		}

		EditorView->Destroy();

		delete EditorView;
	}

	return 0;
}
