#include "buffer.h"

// ----------------------------------------------------------------------------------------------------------------------------

CBuffer::CBuffer()
{
	SetDefaults();
}

CBuffer::~CBuffer()
{
	Empty();
}

int CBuffer::AddData(void *Data, int DataSize)
{
	int Remaining = BufferSize - Position;

	if(DataSize > Remaining)
	{
		BYTE *OldBuffer = Buffer;
		int OldBufferSize = BufferSize;

		int Needed = DataSize - Remaining;

		BufferSize += Needed > BUFFER_SIZE_INCREMENT ? Needed : BUFFER_SIZE_INCREMENT;

		Buffer = new BYTE[BufferSize];

		memcpy(Buffer, OldBuffer, OldBufferSize);

		delete [] OldBuffer;
	}

	memcpy(Buffer + Position, Data, DataSize);

	int Position = this->Position;

	this->Position += DataSize;

	return Position;
}

void CBuffer::DeleteData(int Position, int Size)
{
	while(Position + Size < this->Position)
	{
		Buffer[Position] = Buffer[Position + Size];
		Position++;
	}

	this->Position -= Size;
}

void CBuffer::Empty()
{
	delete [] Buffer;

	SetDefaults();
}

void CBuffer::FreeUnusedMemory()
{
	BYTE *OldBuffer = Buffer;

	BufferSize = Position;

	Buffer = new BYTE[BufferSize];

	memcpy(Buffer, OldBuffer, BufferSize);

	delete [] OldBuffer;
}

BYTE *CBuffer::GetData()
{
	return Buffer;
}

int CBuffer::GetDataSize()
{
	return Position;
}

void CBuffer::SetDefaults()
{
	Buffer = NULL;

	BufferSize = 0;
	Position = 0;
}
