#include "editorview.h"

// ----------------------------------------------------------------------------------------------------------------------------

CEditorView *EditorView = NULL;

// ----------------------------------------------------------------------------------------------------------------------------

LRESULT CALLBACK EditorViewWndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_CLOSE:
			if(EditorView != NULL) EditorView->OnClose();
			break;

		case WM_COMMAND:
			if(EditorView != NULL) EditorView->OnCommand(LOWORD(wParam));
			break;

		case WM_SIZE:
			if(EditorView != NULL) EditorView->OnSize(LOWORD(lParam), HIWORD(lParam));
			break;

		default:
			return DefWindowProc(hWnd, uiMsg, wParam, lParam);
	}

	return 0;
}

// ----------------------------------------------------------------------------------------------------------------------------

CEditorView::CEditorView()
{
	OpenGLView = new COpenGLView();

	EditorView = this;
}

CEditorView::~CEditorView()
{
	delete OpenGLView;
}

bool CEditorView::Init(HINSTANCE hInstance, char *Title, int Width, int Height)
{
	this->Title = Title;
	this->Width = Width;
	this->Height = Height;

	WNDCLASSEX WndClassEx;

	memset(&WndClassEx, 0, sizeof(WNDCLASSEX));

	WndClassEx.cbSize = sizeof(WNDCLASSEX);
	WndClassEx.style = CS_HREDRAW | CS_VREDRAW;
	WndClassEx.lpfnWndProc = EditorViewWndProc;
	WndClassEx.hInstance = hInstance;
	WndClassEx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hCursor = LoadCursor(NULL, IDC_ARROW);
	WndClassEx.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
	WndClassEx.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
	WndClassEx.lpszClassName = "EditorViewClass";

	if(RegisterClassEx(&WndClassEx) == 0)
	{
		ErrorLog.Set("RegisterClassEx failed!");
		return false;
	}

	DWORD Style = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	hWnd = CreateWindowEx(WS_EX_APPWINDOW, WndClassEx.lpszClassName, Title, Style, 0, 0, Width, Height, NULL, NULL, hInstance, NULL);

	if(hWnd == NULL)
	{
		ErrorLog.Set("CreateWindowEx failed!");
		return false;
	}

	if(OpenGLView != NULL)
	{
		return OpenGLView->Init(hInstance, hWnd, Width, Height, 4);
	}

	return true;
}

void CEditorView::Show(bool Maximized)
{
	RECT dRect, wRect, cRect;

	GetWindowRect(GetDesktopWindow(), &dRect);
	GetWindowRect(hWnd, &wRect);
	GetClientRect(hWnd, &cRect);

	wRect.right += Width - cRect.right;
	wRect.bottom += Height - cRect.bottom;
	wRect.right -= wRect.left;
	wRect.bottom -= wRect.top;
	wRect.left = dRect.right / 2 - wRect.right / 2;
	wRect.top = dRect.bottom / 2 - wRect.bottom / 2;

	MoveWindow(hWnd, wRect.left, wRect.top, wRect.right, wRect.bottom, FALSE);

	ShowWindow(hWnd, Maximized ? SW_SHOWMAXIMIZED : SW_SHOWNORMAL);

	if(OpenGLView != NULL)
	{
		OpenGLView->Show();
		OpenGLView->SetFocus();
	}
}

void CEditorView::Destroy()
{
	if(OpenGLView != NULL)
	{
		OpenGLView->Destroy();
	}

	DestroyWindow(hWnd);
}

void CEditorView::Exit()
{
	PostQuitMessage(0);
}

void CEditorView::OnClose()
{
	Exit();
}

void CEditorView::OnCommand(int ID)
{
	switch(ID)
	{
		case ID_FILE_EXIT:
			OnFileExit();
			break;

		case ID_FILE_NEW:
			OnFileNew();
			break;

		case ID_FILE_OPEN:
			OnFileOpen();
			break;

		case ID_FILE_SAVE:
			OnFileSave();
			break;

		case ID_FILE_SAVE_AS:
			OnFileSaveAs();
			break;

		case ID_HELP_ABOUT:
			OnHelpAbout();
			break;
	}
}

void CEditorView::OnFileExit()
{
	Exit();
}

void CEditorView::OnFileNew()
{
}

void CEditorView::OnFileOpen()
{
	OPENFILENAME ofn;
	char FileName[MAX_PATH];

	memset(&ofn, 0, sizeof(ofn));
	FileName[0] = 0;

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFilter = "All\0*.*\0Objects\0*.OBJ\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	if(GetOpenFileName(&ofn) == TRUE)
	{
		MessageBox(hWnd, FileName, "Info", MB_OK | MB_ICONINFORMATION);
	}

	if(OpenGLView != NULL)
	{
		OpenGLView->SetFocus();
	}
}

void CEditorView::OnFileSave()
{
}

void CEditorView::OnFileSaveAs()
{
	OPENFILENAME ofn;
	char FileName[MAX_PATH];

	memset(&ofn, 0, sizeof(ofn));
	FileName[0] = 0;

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFilter = "All\0*.*\0Objects\0*.OBJ\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;

	if(GetSaveFileName(&ofn) == TRUE)
	{
		MessageBox(hWnd, FileName, "Info", MB_OK | MB_ICONINFORMATION);
	}

	if(OpenGLView != NULL)
	{
		OpenGLView->SetFocus();
	}
}

BOOL CALLBACK AboutDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) 
{ 
	switch (message) 
	{ 
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg, wParam);
					return TRUE;
			}
	}

	return FALSE;
} 
void CEditorView::OnHelpAbout()
{
	SetFocus(hWnd);

	DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_ABOUT), hWnd, AboutDialogProc);

	if(OpenGLView != NULL)
	{
		OpenGLView->SetFocus();
	}
}

void CEditorView::OnSize(int Width, int Height)
{
	this->Width = Width;
	this->Height = Height;

	if(OpenGLView != NULL)
	{
		OpenGLView->Move(0, 0, Width, Height);
	}
}
