#include "grid.h"

// ----------------------------------------------------------------------------------------------------------------------------

class CMyOpenGLRenderer : public COpenGLRenderer
{
protected:
	mat4x4 ViewMatrixInverse, ProjectionMatrixInverse;

protected:
	CFont Font;

protected:
	CGrid Grid;

protected:
	CBuffer Vertices, Indices;
	int SelectedVertexIndex, NewIndices[3], NewIndicesCount;
	
public:
	CMyOpenGLRenderer();
	~CMyOpenGLRenderer();

	bool Init();
	void Resize(int Width, int Height);
	void Render();
	bool Animate(float FrameTime);
	void Destroy();

	int SelectVertex(const vec3 &Point);
	
	void OnCommand(int ID);
	void OnDelete();

	bool OnCameraKeys(SHORT Keys, float FrameTime, vec3 &Movement);
	void OnKeyDown(UINT Key);
	void OnLButtonDown(int X, int Y);
	void OnMouseMove(int X, int Y, bool LButtonDown, bool RButtonDown);
	void OnMouseWheel(short zDelta);
	void OnRButtonDown(int X, int Y);
};
