#include "myopenglrenderer.h"

// ----------------------------------------------------------------------------------------------------------------------------

class COpenGLView
{
private:
	int Width, Height, Samples;
	HMENU PopupMenu;
	HWND hWnd;
	HGLRC hGLRC;
	bool Focus, MouseMoved;

private:
	CMyOpenGLRenderer *MyOpenGLRenderer;

public:
	COpenGLView();
	~COpenGLView();

	bool Init(HINSTANCE hInstance, HWND hWndParent, int Width, int Height, int Samples);
	void Move(int X, int Y, int Width, int Height);
	void SetFocus();
	void Show();
	void Destroy();
	
	void OnCommand(int ID);
	void OnKeyDown(UINT Key);
	void OnKillFocus();
	void OnLButtonDown(int X, int Y);
	void OnMouseMove(int X, int Y);
	void OnMouseWheel(short zDelta);
	void OnPaint();
	void OnRButtonDown(int X, int Y);
	void OnRButtonUp(int X, int Y);
	void OnSetFocus();
	void OnSize(int Width, int Height);
};
