#include "openglrenderer.h"

// ----------------------------------------------------------------------------------------------------------------------------

COpenGLRenderer::COpenGLRenderer()
{
	Camera = NULL;
}

COpenGLRenderer::~COpenGLRenderer()
{
}

void COpenGLRenderer::MoveCamera(const vec3 &Movement)
{
	if(Camera != NULL)
	{
		Camera->Move(Movement);
	}
}

bool COpenGLRenderer::OnCameraKeys(SHORT Keys, float FrameTime, vec3 &Movement)
{
	if(Camera != NULL)
	{
		return Camera->OnKeys(Keys, FrameTime, Movement);
	}

	return false;
}

void COpenGLRenderer::OnKeyDown(UINT Key)
{
}

void COpenGLRenderer::OnLButtonDown(int X, int Y)
{
	LastX = X;
	LastY = Y;
}

void COpenGLRenderer::OnMouseMove(int X, int Y, bool LButtonDown, bool RButtonDown)
{
	if(RButtonDown)
	{
		if(Camera != NULL)
		{
			Camera->OnMouseMove(LastX - X, LastY - Y);
		}
	}

	LastX = X;
	LastY = Y;
}

void COpenGLRenderer::OnMouseWheel(short zDelta)
{
	if(Camera != NULL)
	{
		Camera->OnMouseWheel(zDelta);
	}
}

void COpenGLRenderer::OnRButtonDown(int X, int Y)
{
	LastX = X;
	LastY = Y;
}
