#version 120

uniform sampler2D SSAOBuffer, DepthBuffer;
uniform float PixelSizeX, fs, fd;

float Offsets[8] = float[](-4.0, -3.0, -2.0, -1.0, 1.0, 2.0, 3.0, 4.0);
float BlurWeights[8] = float[](1.0, 2.0, 3.0, 4.0, 4.0, 3.0, 2.0, 1.0);

void main()
{
	float BlurWeightsSum = 5.0;

	float SSAO = texture2D(SSAOBuffer, gl_TexCoord[0].st).r * BlurWeightsSum;
	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	float Factor = fs - fd * Depth;

	for(int i = 0; i < 8; i++)
	{
		vec2 TexCoord = vec2(gl_TexCoord[0].s + Offsets[i] * PixelSizeX, gl_TexCoord[0].t);

		float depth = texture2D(DepthBuffer, TexCoord).r;

		if(abs(Depth - depth) < Factor)
		{
			SSAO += texture2D(SSAOBuffer, TexCoord).r * BlurWeights[i];
			BlurWeightsSum += BlurWeights[i];
		}
	}

	gl_FragColor = vec4(vec3(SSAO / BlurWeightsSum), 1.0);
}
