#version 120

uniform sampler2D ColorBuffer, NormalBuffer, DepthBuffer, SSAOBuffer;
uniform mat4x4 ProjectionBiasMatrixInverse;
uniform bool Lighting, ApplySSAO;

void main()
{
	gl_FragColor = texture2D(ColorBuffer, gl_TexCoord[0].st);

	float Depth = texture2D(DepthBuffer, gl_TexCoord[0].st).r;

	if(Depth < 1.0)
	{
		vec3 Normal = normalize(texture2D(NormalBuffer, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

		vec4 Position = ProjectionBiasMatrixInverse * vec4(gl_TexCoord[0].st, Depth, 1.0);
		Position /= Position.w;

		float SSAO = ApplySSAO ? texture2D(SSAOBuffer, gl_TexCoord[0].st).r : 1.0;

		if(Lighting)
		{
			vec3 LightDirection = normalize(vec3(0.0) - Position.xyz);

			float NdotLD = max(dot(Normal, LightDirection), 0.0);

			gl_FragColor.rgb *= 0.5 * SSAO + 0.5 * NdotLD;
		}
		else
		{
			gl_FragColor.rgb *= SSAO;
		}
	}
}
