#include "shaderprogram.h"

// ----------------------------------------------------------------------------------------------------------------------------

#define RADIUS 0.15625f

// ----------------------------------------------------------------------------------------------------------------------------

class CTriangle
{
public:
	vec3 Vertex[3], Edge[3], Normal[4];
	float EdgeLength[3], D[4];
	bool Close;
};

// ----------------------------------------------------------------------------------------------------------------------------

class CObject
{
public:
	mat3x3 NormalMatrix;
	mat4x4 ModelMatrix;
	CTexture Texture;
	CBuffer Buffer;
	GLuint VBO;
	int VertexOffset, Stride, VerticesCount, TrianglesCount;
	CTriangle *Triangles;
	vec3 Min, Max;
	bool Close;

public:
	CObject();
	~CObject();

	void AddData(void *Data, int DataSize);
	void Destroy();
	void InitVBO(int VertexOffset, int Stride);
	void PrepareTriangles();
	void SetModelMatrix(const mat4x4 &ModelMatrix);

private:
	void SetDefaults();
};
