// ----------------------------------------------------------------------------------------------------------------------------

#include <windows.h>

#include <gl/glew.h>
#include <gl/wglew.h>

#include "string.h"

#include "joglni.h"

// ----------------------------------------------------------------------------------------------------------------------------

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glew32.lib")

// ----------------------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBegin(JNIEnv *env, jobject obj, jint mode) { glBegin(mode); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindTexture(JNIEnv *env, jobject obj, jint target, jint texture) { glBindTexture(target, texture); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glBlendFunc(JNIEnv *env, jobject obj, jint sfactor, jint dfactor) { glBlendFunc(sfactor, dfactor); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glClear(JNIEnv *env, jobject obj, jint mask) { glClear(mask); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glColor3f(JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue) { glColor3f(red, green, blue); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glColor4f(JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue, jfloat alpha) { glColor4f(red, green, blue, alpha); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glColorPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset)
{
	if(ptr == NULL)
	{
		glColorPointer(size, type, stride, (void*)offset);
	}
	else
	{
		jbyte *Ptr = env->GetByteArrayElements(ptr, NULL);
		glColorPointer(size, type, stride, Ptr + offset);
		env->ReleaseByteArrayElements(ptr, Ptr, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glCullFace(JNIEnv *env, jobject obj, jint mode) { glCullFace(mode); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteTextures(JNIEnv *env, jobject obj, jint n, jintArray textures)
{
	if(textures != NULL)
	{
		jint *Textures = env->GetIntArrayElements(textures, NULL);
		glDeleteTextures(n, (const GLuint*)Textures);
		env->ReleaseIntArrayElements(textures, Textures, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glDisable(JNIEnv *env, jobject obj, jint cap) { glDisable(cap); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDisableClientState(JNIEnv *env, jobject obj, jint cap) { glDisableClientState(cap); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawArrays(JNIEnv *env, jobject obj, jint mode, jint first, jint count) { glDrawArrays(mode, first, count); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawBuffer(JNIEnv *env, jobject obj, jint mode) { glDrawBuffer(mode); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glDrawElements(JNIEnv *env, jobject obj, jint mode, jint count, jint type, jbyteArray indices)
{
	if(indices == NULL)
	{
		glDrawElements(mode, count, type, NULL);
	}
	else
	{
		jbyte *Indices = env->GetByteArrayElements(indices, NULL);
		glDrawElements(mode, count, type, Indices);
		env->ReleaseByteArrayElements(indices, Indices, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnable(JNIEnv *env, jobject obj, jint cap) { glEnable(cap); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnableClientState(JNIEnv *env, jobject obj, jint cap) { glEnableClientState(cap); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glEnd(JNIEnv *env, jobject obj) { glEnd(); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenTextures(JNIEnv *env, jobject obj, jint n, jintArray textures)
{
	if(textures != NULL)
	{
		jint *Textures = env->GetIntArrayElements(textures, NULL);
		glGenTextures(n, (GLuint*)Textures);
		env->ReleaseIntArrayElements(textures, Textures, 0);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glGetIntegerv(JNIEnv *env, jobject obj, jint pname, jintArray params)
{
	if(params != NULL)
	{
		jint *Params = env->GetIntArrayElements(params, NULL);
		glGetIntegerv(pname, (GLint*)Params);
		env->ReleaseIntArrayElements(params, Params, 0);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glLineWidth(JNIEnv *env, jobject obj, jfloat width) { glLineWidth(width); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glLoadIdentity(JNIEnv *env, jobject obj) { glLoadIdentity(); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glLoadMatrixf(JNIEnv *env, jobject obj, jfloatArray m)
{
	if(m != NULL)
	{
		jfloat *M = env->GetFloatArrayElements(m, NULL);
		glLoadMatrixf(M);
		env->ReleaseFloatArrayElements(m, M, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glMatrixMode(JNIEnv *env, jobject obj, jint mode) { glMatrixMode(mode); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultMatrixf(JNIEnv *env, jobject obj, jfloatArray m)
{
	if(m != NULL)
	{
		jfloat *M = env->GetFloatArrayElements(m, NULL);
		glMultMatrixf(M);
		env->ReleaseFloatArrayElements(m, M, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glNormal3f(JNIEnv *env, jobject obj, jfloat nx, jfloat ny, jfloat nz) { glNormal3f(nx, ny, nz); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glNormalPointer(JNIEnv *env, jobject obj, jint type, jint stride, jbyteArray ptr, jint offset)
{
	if(ptr == NULL)
	{
		glNormalPointer(type, stride, (void*)offset);
	}
	else
	{
		jbyte *Ptr = env->GetByteArrayElements(ptr, NULL);
		glNormalPointer(type, stride, Ptr + offset);
		env->ReleaseByteArrayElements(ptr, Ptr, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glReadBuffer(JNIEnv *env, jobject obj, jint mode) { glReadBuffer(mode); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glRotatef(JNIEnv *env, jobject obj, jfloat angle, jfloat x, jfloat y, jfloat z) { glRotatef(angle, x, y, z); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glScalef(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z) { glScalef(x, y, z); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoord2f(JNIEnv *env, jobject obj, jfloat s, jfloat t) { glTexCoord2f(s, t); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoord3f(JNIEnv *env, jobject obj, jfloat s, jfloat t, jfloat r) { glTexCoord3f(s, t, r); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexCoordPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset)
{
	if(ptr == NULL)
	{
		glTexCoordPointer(size, type, stride, (void*)offset);
	}
	else
	{
		jbyte *Ptr = env->GetByteArrayElements(ptr, NULL);
		glTexCoordPointer(size, type, stride, Ptr + offset);
		env->ReleaseByteArrayElements(ptr, Ptr, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexImage2D(JNIEnv *env, jobject obj, jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jbyteArray pixels)
{
	if(pixels == NULL)
	{
		glTexImage2D(target, level, internalFormat, width, height, border, format, type, NULL);
	}
	else
	{
		jbyte *Pixels = env->GetByteArrayElements(pixels, NULL);
		glTexImage2D(target, level, internalFormat, width, height, border, format, type, Pixels);
		env->ReleaseByteArrayElements(pixels, Pixels, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexParameteri(JNIEnv *env, jobject obj, jint target, jint pname, jint param) { glTexParameteri(target, pname, param); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glTranslatef(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z) { glTranslatef(x, y, z); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertex2f(JNIEnv *env, jobject obj, jfloat x, jfloat y) { glVertex2f(x, y); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertex3f(JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z) { glVertex3f(x, y, z); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glVertexPointer(JNIEnv *env, jobject obj, jint size, jint type, jint stride, jbyteArray ptr, jint offset)
{
	if(ptr == NULL)
	{
		glVertexPointer(size, type, stride, (void*)offset);
	}
	else
	{
		jbyte *Ptr = env->GetByteArrayElements(ptr, NULL);
		glVertexPointer(size, type, stride, Ptr + offset);
		env->ReleaseByteArrayElements(ptr, Ptr, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glViewport(JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height) { glViewport(x, y, width, height); }

// OpenGL 1.2 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glTexImage3D(JNIEnv *env, jobject obj, jint target, jint level, jint internalFormat, jint width, jint height, jint depth, jint border, jint format, jint type, jbyteArray pixels)
{
	if(pixels == NULL)
	{
		glTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, NULL);
	}
	else
	{
		jbyte *Pixels = env->GetByteArrayElements(pixels, NULL);
		glTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, Pixels);
		env->ReleaseByteArrayElements(pixels, Pixels, JNI_ABORT);
	}
}

// OpenGL 1.3 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glActiveTexture(JNIEnv *env, jobject obj, jint texture) { glActiveTexture(texture); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultiTexCoord2f(JNIEnv *env, jobject obj, jint target, jfloat s, jfloat t) { glMultiTexCoord2f(target, s, t); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_glMultiTexCoord3f(JNIEnv *env, jobject obj, jint target, jfloat s, jfloat t, jfloat r) { glMultiTexCoord3f(target, s, t, r); }

// OpenGL 1.5 -----------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindBuffer(JNIEnv *env, jobject obj, jint target, jint buffer) { glBindBuffer(target, buffer); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBufferData(JNIEnv *env, jobject obj, jint target, jint size, jbyteArray data, jint usage)
{
	if(data != NULL)
	{
		jbyte *Data = env->GetByteArrayElements(data, NULL);
		glBufferData(target, size, Data, usage);
		env->ReleaseByteArrayElements(data, Data, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteBuffers(JNIEnv *env, jobject obj, jint n, jintArray buffers)
{
	if(buffers != NULL)
	{
		jint *Buffers = env->GetIntArrayElements(buffers, NULL);
		glDeleteBuffers(n, (const GLuint*)Buffers);
		env->ReleaseIntArrayElements(buffers, Buffers, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenBuffers(JNIEnv *env, jobject obj, jint n, jintArray buffers)
{
	if(buffers != NULL)
	{
		jint *Buffers = env->GetIntArrayElements(buffers, NULL);
		glGenBuffers(n, (GLuint*)Buffers);
		env->ReleaseIntArrayElements(buffers, Buffers, 0);
	}
}

// GL_ARB_texture_float -------------------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1ARB_1texture_1float(JNIEnv *env, jobject obj) { return GLEW_ARB_texture_float; }

// GL_ARB_texture_non_power_of_two --------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1ARB_1texture_1non_1power_1of_1two(JNIEnv *env, jobject obj) { return GLEW_ARB_texture_non_power_of_two; }

// GL_EXT_framebuffer_object --------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glBindFramebufferEXT(JNIEnv *env, jobject obj, jint target, jint framebuffer) { glBindFramebufferEXT(target, framebuffer); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glDeleteFramebuffersEXT(JNIEnv *env, jobject obj, jint n, jintArray framebuffers)
{
	if(framebuffers != NULL)
	{
		jint *Framebuffers = env->GetIntArrayElements(framebuffers, NULL);
		glDeleteFramebuffersEXT(n, (const GLuint*)Framebuffers);
		env->ReleaseIntArrayElements(framebuffers, Framebuffers, JNI_ABORT);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glFramebufferTexture2DEXT(JNIEnv *env, jobject obj, jint target, jint attachment, jint textarget, jint texture, jint level) { glFramebufferTexture2DEXT(target, attachment, textarget, texture, level); }

JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenFramebuffersEXT(JNIEnv *env, jobject obj, jint n, jintArray framebuffers)
{
	if(framebuffers != NULL)
	{
		jint *Framebuffers = env->GetIntArrayElements(framebuffers, NULL);
		glGenFramebuffersEXT(n, (GLuint*)Framebuffers);
		env->ReleaseIntArrayElements(framebuffers, Framebuffers, 0);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGL_glGenerateMipmapEXT(JNIEnv *env, jobject obj, jint target) { glGenerateMipmapEXT(target); }

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1framebuffer_1object(JNIEnv *env, jobject obj) { return GLEW_EXT_framebuffer_object; }

// GL_EXT_texture_array -------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_glFramebufferTextureLayerEXT(JNIEnv *env, jobject obj, jint target, jint attachment, jint texture, jint level, jint layer) { glFramebufferTextureLayerEXT(target, attachment, texture, level, layer); }

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1texture_1array(JNIEnv *env, jobject obj) { return GLEW_EXT_texture_array; }

// GL_EXT_texture_filter_anisotropic ------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGL_GL_1EXT_1texture_1filter_1anisotropic(JNIEnv *env, jobject obj) { return GLEW_EXT_texture_filter_anisotropic; }

// GLU ------------------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGL_gluPerspective(JNIEnv *env, jobject obj, jdouble fovy, jdouble aspect, jdouble zNear, jdouble zFar) { gluPerspective(fovy, aspect, zNear, zFar); }
JNIEXPORT void JNICALL Java_joglni_OpenGL_gluLookAt(JNIEnv *env, jobject obj, jdouble eyeX, jdouble eyeY, jdouble eyeZ, jdouble centerX, jdouble centerY, jdouble centerZ, jdouble upX, jdouble upY, jdouble upZ) { gluLookAt(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ); }

// ----------------------------------------------------------------------------------------------------------------------------

CString ErrorLog;

// OpenGLRenderer -------------------------------------------------------------------------------------------------------------

JNIEXPORT void JNICALL Java_joglni_OpenGLRenderer_addError(JNIEnv *env, jobject obj, jstring error)
{
	const char *Error = env->GetStringUTFChars(error, NULL);

	ErrorLog.Append(Error);
	ErrorLog.Append("\r\n");

	env->ReleaseStringUTFChars(error, Error);
}

// ----------------------------------------------------------------------------------------------------------------------------

HWND Wnd = NULL;
CString Title;
int Width = 0, Height = 0, Samples = 0;
HGLRC GLRC = NULL;

// ----------------------------------------------------------------------------------------------------------------------------

int gl_max_texture_max_anisotropy_ext = 0;

// ----------------------------------------------------------------------------------------------------------------------------

JNIEnv *Env = NULL;

jobject OpenGLViewJObject = NULL;

jmethodID OnPaintJMethodId = NULL;
jmethodID OnSizeJMethodId = NULL;

// ----------------------------------------------------------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam);

// OpenGLView -----------------------------------------------------------------------------------------------------------------

JNIEXPORT jboolean JNICALL Java_joglni_OpenGLView_create21(JNIEnv *env, jobject obj, jstring title, jint width, jint height, jint samples)
{
	const char *Title = env->GetStringUTFChars(title, NULL);

	::Title.Set(Title);

	env->ReleaseStringUTFChars(title, Title);

	Width = width;
	Height = height;

	HINSTANCE hInstance = NULL;

	WNDCLASSEX WndClassEx;

	memset(&WndClassEx, 0, sizeof(WNDCLASSEX));

	WndClassEx.cbSize = sizeof(WNDCLASSEX);
	WndClassEx.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	WndClassEx.lpfnWndProc = WndProc;
	WndClassEx.hInstance = hInstance;
	WndClassEx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	WndClassEx.hCursor = LoadCursor(NULL, IDC_ARROW);
	WndClassEx.lpszClassName = "Win32OpenGL21NativeWindowClass";

	if(RegisterClassEx(&WndClassEx) == 0)
	{
		ErrorLog.Set("RegisterClassEx failed!");
		return false;
	}

	DWORD Style = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	Wnd = CreateWindowEx(WS_EX_APPWINDOW, WndClassEx.lpszClassName, ::Title, Style, 0, 0, Width, Height, NULL, NULL, hInstance, NULL);

	if(Wnd == NULL)
	{
		ErrorLog.Set("CreateWindowEx failed!");
		return false;
	}

	HDC DC = GetDC(Wnd);

	if(DC == NULL)
	{
		ErrorLog.Set("GetDC failed!");
		return false;
	}

	PIXELFORMATDESCRIPTOR pfd;

	memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 32;
	pfd.cDepthBits = 24;
	pfd.iLayerType = PFD_MAIN_PLANE;

	int PixelFormat = ChoosePixelFormat(DC, &pfd);

	if(PixelFormat == 0)
	{
		ErrorLog.Set("ChoosePixelFormat failed!");
		return false;
	}

	static int MSAAPixelFormat = 0;

	if(SetPixelFormat(DC, MSAAPixelFormat == 0 ? PixelFormat : MSAAPixelFormat, &pfd) == FALSE)
	{
		ErrorLog.Set("SetPixelFormat failed!");
		return false;
	}

	GLRC = wglCreateContext(DC);

	if(GLRC == NULL)
	{
		ErrorLog.Set("wglCreateContext failed!");
		return false;
	}

	if(wglMakeCurrent(DC, GLRC) == FALSE)
	{
		ErrorLog.Set("wglMakeCurrent failed!");
		return false;
	}

	if(glewInit() != GLEW_OK)
	{
		ErrorLog.Set("glewInit failed!");
		return false;
	}

	if(!GLEW_VERSION_2_1)
	{
		ErrorLog.Set("OpenGL 2.1 not supported!");
		return false;
	}

	if(MSAAPixelFormat == 0 && samples > 0)
	{
		if(GLEW_ARB_multisample && WGLEW_ARB_pixel_format)
		{
			while(samples > 0)
			{
				UINT NumFormats = 0;

				int PFAttribs[] =
				{
					WGL_DRAW_TO_WINDOW_ARB, GL_TRUE,
					WGL_SUPPORT_OPENGL_ARB, GL_TRUE,
					WGL_DOUBLE_BUFFER_ARB, GL_TRUE,
					WGL_PIXEL_TYPE_ARB, WGL_TYPE_RGBA_ARB,
					WGL_COLOR_BITS_ARB, 32,
					WGL_DEPTH_BITS_ARB, 24,
					WGL_ACCELERATION_ARB, WGL_FULL_ACCELERATION_ARB,
					WGL_SAMPLE_BUFFERS_ARB, GL_TRUE,
					WGL_SAMPLES_ARB, samples,
					0
				};

				if(wglChoosePixelFormatARB(DC, PFAttribs, NULL, 1, &MSAAPixelFormat, &NumFormats) == TRUE && NumFormats > 0) break;

				samples--;
			}

			wglDeleteContext(GLRC);
			DestroyWindow(Wnd);
			UnregisterClass(WndClassEx.lpszClassName, hInstance);

			return Java_joglni_OpenGLView_create21(env, obj, title, width, height, samples);
		}
		else
		{
			samples = 0;
		}
	}

	Samples = samples;

	if(GLEW_EXT_texture_filter_anisotropic)
	{
		glGetIntegerv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &gl_max_texture_max_anisotropy_ext);
	}

	if(WGLEW_EXT_swap_control)
	{
		wglSwapIntervalEXT(0);
	}

	Env = env;

	OpenGLViewJObject = obj;

	jclass OpenGLViewJClass = env->GetObjectClass(OpenGLViewJObject);

	OnPaintJMethodId = env->GetMethodID(OpenGLViewJClass, "onPaint", "(F)V");
	OnSizeJMethodId = env->GetMethodID(OpenGLViewJClass, "onSize", "(II)V");

	return env->CallBooleanMethod(obj, env->GetMethodID(env->GetObjectClass(obj), "onCreate", "()Z"));
}

JNIEXPORT void JNICALL Java_joglni_OpenGLView_destroy(JNIEnv *env, jobject obj)
{
	env->CallBooleanMethod(obj, env->GetMethodID(env->GetObjectClass(obj), "onDestroy", "()V"));

	wglDeleteContext(GLRC);
	DestroyWindow(Wnd);
}

JNIEXPORT void JNICALL Java_joglni_OpenGLView_displayMessage(JNIEnv *env, jobject obj, jstring title, jstring message)
{
	const char *Title = env->GetStringUTFChars(title, NULL);
	const char *Message = env->GetStringUTFChars(message, NULL);

	MessageBox(NULL, Message, Title, MB_OK);

	env->ReleaseStringUTFChars(title, Title);
	env->ReleaseStringUTFChars(message, Message);
}

JNIEXPORT jstring JNICALL Java_joglni_OpenGLView_getErrorLog(JNIEnv *env, jobject obj)
{
	return env->NewStringUTF(ErrorLog);
}

JNIEXPORT void JNICALL Java_joglni_OpenGLView_mainLoop(JNIEnv *env, jobject obj)
{
	MSG Msg;

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
}

JNIEXPORT void JNICALL Java_joglni_OpenGLView_show(JNIEnv *env, jobject obj, jboolean maximized)
{
	RECT dRect, wRect, cRect;

	GetWindowRect(GetDesktopWindow(), &dRect);
	GetWindowRect(Wnd, &wRect);
	GetClientRect(Wnd, &cRect);

	wRect.right += Width - cRect.right;
	wRect.bottom += Height - cRect.bottom;
	wRect.right -= wRect.left;
	wRect.bottom -= wRect.top;
	wRect.left = dRect.right / 2 - wRect.right / 2;
	wRect.top = dRect.bottom / 2 - wRect.bottom / 2;

	MoveWindow(Wnd, wRect.left, wRect.top, wRect.right, wRect.bottom, FALSE);

	ShowWindow(Wnd, maximized ? SW_SHOWMAXIMIZED : SW_SHOWNORMAL);
}

// ----------------------------------------------------------------------------------------------------------------------------

void OnPaint()
{
	static DWORD LastFPSTime = GetTickCount(), LastFrameTime = LastFPSTime, FPS = 0;

	PAINTSTRUCT ps;

	HDC DC = BeginPaint(Wnd, &ps);

	DWORD Time = GetTickCount();

	float FrameTime = (Time - LastFrameTime) * 0.001f;

	LastFrameTime = Time;

	if(Time - LastFPSTime > 1000)
	{
		CString Text = Title;

		Text.Append(" - %dx%d", Width, Height);
		Text.Append(", ATF %dx", gl_max_texture_max_anisotropy_ext);
		Text.Append(", MSAA %dx", Samples);
		Text.Append(", FPS: %d", FPS);
		Text.Append(" - %s", glGetString(GL_RENDERER));

		SetWindowText(Wnd, Text);

		LastFPSTime = Time;
		FPS = 0;
	}
	else
	{
		FPS++;
	}

	Env->CallVoidMethod(OpenGLViewJObject, OnPaintJMethodId, FrameTime);

	SwapBuffers(DC);

	EndPaint(Wnd, &ps);

	InvalidateRect(Wnd, NULL, FALSE);
}

void OnSize(int width, int height)
{
	Width = width;
	Height = height;

	Env->CallVoidMethod(OpenGLViewJObject, OnSizeJMethodId, Width, Height);
}

// ----------------------------------------------------------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_CLOSE:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			OnPaint();
			break;

		case WM_SIZE:
			OnSize(LOWORD(lParam), HIWORD(lParam));
			break;

		default:
			return DefWindowProc(hWnd, uiMsg, wParam, lParam);
	}

	return 0;
}

// ----------------------------------------------------------------------------------------------------------------------------
