package joglni;

public class OpenGL
{
    // ------------------------------------------------------------------------------------------------------------------------

    static
    {
        System.loadLibrary("joglni");
    }

    // OpenGL 1.1 -------------------------------------------------------------------------------------------------------------

    protected static final int GL_FALSE = 0;
    protected static final int GL_NONE = 0;
    protected static final int GL_POINTS = 0x0000;
    protected static final int GL_TRUE = 1;
    protected static final int GL_LINES = 0x0001;
    protected static final int GL_TRIANGLES = 0x0004;
    protected static final int GL_QUADS = 0x0007;
    protected static final int GL_DEPTH_BUFFER_BIT = 0x00000100;
    protected static final int GL_SRC_COLOR = 0x0300;
    protected static final int GL_ONE_MINUS_SRC_COLOR = 0x0301;
    protected static final int GL_SRC_ALPHA = 0x0302;
    protected static final int GL_ONE_MINUS_SRC_ALPHA = 0x0303;
    protected static final int GL_DST_ALPHA = 0x0304;
    protected static final int GL_ONE_MINUS_DST_ALPHA = 0x0305;
    protected static final int GL_DST_COLOR = 0x0306;
    protected static final int GL_ONE_MINUS_DST_COLOR = 0x0307;
    protected static final int GL_SRC_ALPHA_SATURATE = 0x0308;
    protected static final int GL_FRONT = 0x0404;
    protected static final int GL_BACK = 0x0405;
    protected static final int GL_FRONT_AND_BACK = 0x0408;
    protected static final int GL_CULL_FACE = 0x0B44;
    protected static final int GL_DEPTH_TEST = 0x0B71;
    protected static final int GL_BLEND = 0x0BE2;
    protected static final int GL_MAX_TEXTURE_SIZE = 0x0D33;
    protected static final int GL_TEXTURE_2D = 0x0DE1;
    protected static final int GL_BYTE = 0x1400;
    protected static final int GL_UNSIGNED_BYTE = 0x1401;
    protected static final int GL_SHORT = 0x1402;
    protected static final int GL_UNSIGNED_SHORT = 0x1403;
    protected static final int GL_INT = 0x1404;
    protected static final int GL_UNSIGNED_INT = 0x1405;
    protected static final int GL_FLOAT = 0x1406;
    protected static final int GL_DOUBLE = 0x140A;
    protected static final int GL_MODELVIEW = 0x1700;
    protected static final int GL_PROJECTION = 0x1701;
    protected static final int GL_DEPTH_COMPONENT = 0x1902;
    protected static final int GL_RGB = 0x1907;
    protected static final int GL_RGBA = 0x1908;
    protected static final int GL_NEAREST = 0x2600;
    protected static final int GL_LINEAR = 0x2601;
    protected static final int GL_NEAREST_MIPMAP_NEAREST = 0x2700;
    protected static final int GL_LINEAR_MIPMAP_NEAREST = 0x2701;
    protected static final int GL_NEAREST_MIPMAP_LINEAR = 0x2702;
    protected static final int GL_LINEAR_MIPMAP_LINEAR = 0x2703;
    protected static final int GL_TEXTURE_MAG_FILTER = 0x2800;
    protected static final int GL_TEXTURE_MIN_FILTER = 0x2801;
    protected static final int GL_TEXTURE_WRAP_S = 0x2802;
    protected static final int GL_TEXTURE_WRAP_T = 0x2803;
    protected static final int GL_CLAMP = 0x2900;
    protected static final int GL_COLOR_BUFFER_BIT = 0x00004000;
    protected static final int GL_RGB8 = 0x8051;
    protected static final int GL_RGBA8 = 0x8058;
    protected static final int GL_VERTEX_ARRAY = 0x8074;
    protected static final int GL_NORMAL_ARRAY = 0x8075;
    protected static final int GL_COLOR_ARRAY = 0x8076;
    protected static final int GL_TEXTURE_COORD_ARRAY = 0x8078;

    protected static final native void glBegin(int mode);
    protected static final native void glBindTexture(int target, int texture);
    protected static final native void glBlendFunc(int sfactor, int dfactor);
    protected static final native void glClear(int mask);
    protected static final native void glColor3f(float red, float green, float blue);
    protected static final native void glColor4f(float red, float green, float blue, float alpha);
    protected static final native void glColorPointer(int size, int type, int stride, byte[] ptr, int offset);
    protected static final native void glCullFace(int mode);
    protected static final native void glDeleteTextures(int n, int[] textures);
    protected static final native void glDisable(int cap);
    protected static final native void glDisableClientState(int cap);
    protected static final native void glDrawArrays(int mode, int first, int count);
    protected static final native void glDrawBuffer(int mode);
    protected static final native void glDrawElements(int mode, int count, int type, byte[] indices);
    protected static final native void glEnable(int cap);
    protected static final native void glEnableClientState(int cap);
    protected static final native void glEnd();
    protected static final native void glGenTextures(int n, int[] textures);
    protected static final native void glGetIntegerv (int pname, int[] params);
    protected static final native void glLineWidth(float width);
    protected static final native void glLoadIdentity();
    protected static final native void glLoadMatrixf(float[] m);
    protected static final native void glMatrixMode(int mode);
    protected static final native void glMultMatrixf(float[] m);
    protected static final native void glNormal3f(float nx, float ny, float nz);
    protected static final native void glNormalPointer(int type, int stride, byte[] ptr, int offset);
    protected static final native void glReadBuffer(int mode);
    protected static final native void glRotatef(float angle, float x, float y, float z);
    protected static final native void glScalef(float x, float y, float z);
    protected static final native void glTexCoord2f(float s, float t);
    protected static final native void glTexCoord3f(float s, float t, float r);
    protected static final native void glTexCoordPointer(int size, int type, int stride, byte[] ptr, int offset);
    protected static final native void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, byte[] pixels);
    protected static final native void glTexParameteri(int target, int pname, int param);
    protected static final native void glTranslatef(float x, float y, float z);
    protected static final native void glVertex2f(float x, float y);
    protected static final native void glVertex3f(float x, float y, float z);
    protected static final native void glVertexPointer(int size, int type, int stride, byte[] ptr, int offset);
    protected static final native void glViewport(int x, int y, int width, int height);

    // OpenGL 1.2 -------------------------------------------------------------------------------------------------------------

    protected static final int GL_TEXTURE_3D = 0x806F;
    protected static final int GL_BGR = 0x80E0;
    protected static final int GL_BGRA = 0x80E1;
    protected static final int GL_CLAMP_TO_EDGE = 0x812F;

    protected static final native void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, byte[] pixels);

    // OpenGL 1.3 -------------------------------------------------------------------------------------------------------------

    protected static final int GL_TEXTURE0 = 0x84C0;
    protected static final int GL_TEXTURE1 = 0x84C1;
    protected static final int GL_TEXTURE2 = 0x84C2;
    protected static final int GL_TEXTURE3 = 0x84C3;
    protected static final int GL_TEXTURE4 = 0x84C4;
    protected static final int GL_TEXTURE5 = 0x84C5;
    protected static final int GL_TEXTURE6 = 0x84C6;
    protected static final int GL_TEXTURE7 = 0x84C7;
    protected static final int GL_TEXTURE8 = 0x84C8;
    protected static final int GL_TEXTURE9 = 0x84C9;
    protected static final int GL_TEXTURE_CUBE_MAP = 0x8513;
    protected static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515;
    protected static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516;
    protected static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517;
    protected static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518;
    protected static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519;
    protected static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A;

    protected static final native void glActiveTexture(int texture);
    protected static final native void glMultiTexCoord2f(int target, float s, float t);
    protected static final native void glMultiTexCoord3f(int target, float s, float t, float r);

    // OpenGL 1.4 -------------------------------------------------------------------------------------------------------------

    protected static final int GL_GENERATE_MIPMAP = 0x8191;
    protected static final int GL_DEPTH_COMPONENT24 = 0x81A6;

    // OpenGL 1.5 -------------------------------------------------------------------------------------------------------------

    protected static final int GL_ARRAY_BUFFER = 0x8892;
    protected static final int GL_ELEMENT_ARRAY_BUFFER = 0x8893;
    protected static final int GL_STATIC_DRAW = 0x88E4;

    protected static final native void glBindBuffer(int target, int buffer);
    protected static final native void glBufferData(int target, int size, byte[] data, int usage);
    protected static final native void glDeleteBuffers(int n, int[] buffers);
    protected static final native void glGenBuffers(int n, int[] buffers);

    // GL_ARB_texture_float ---------------------------------------------------------------------------------------------------

    protected static final int GL_RGBA32F_ARB = 0x8814;
    protected static final int GL_RGBA16F_ARB = 0x881A;

    protected static final native boolean GL_ARB_texture_float();

    // GL_ARB_texture_non_power_of_two ----------------------------------------------------------------------------------------

    protected static final native boolean GL_ARB_texture_non_power_of_two();

    // GL_EXT_framebuffer_object ----------------------------------------------------------------------------------------------

    protected static final int GL_COLOR_ATTACHMENT0_EXT = 0x8CE0;
    protected static final int GL_COLOR_ATTACHMENT1_EXT = 0x8CE1;
    protected static final int GL_COLOR_ATTACHMENT2_EXT = 0x8CE2;
    protected static final int GL_COLOR_ATTACHMENT3_EXT = 0x8CE3;
    protected static final int GL_COLOR_ATTACHMENT4_EXT = 0x8CE4;
    protected static final int GL_COLOR_ATTACHMENT5_EXT = 0x8CE5;
    protected static final int GL_COLOR_ATTACHMENT6_EXT = 0x8CE6;
    protected static final int GL_COLOR_ATTACHMENT7_EXT = 0x8CE7;
    protected static final int GL_COLOR_ATTACHMENT8_EXT = 0x8CE8;
    protected static final int GL_COLOR_ATTACHMENT9_EXT = 0x8CE9;
    protected static final int GL_DEPTH_ATTACHMENT_EXT = 0x8D00;
    protected static final int GL_FRAMEBUFFER_EXT = 0x8D40;

    protected static final native void glBindFramebufferEXT(int target, int framebuffer);
    protected static final native void glDeleteFramebuffersEXT(int n, int[] framebuffers);
    protected static final native void glFramebufferTexture2DEXT(int target, int attachment, int textarget, int texture, int level);
    protected static final native void glGenFramebuffersEXT(int n, int[] framebuffers);
    protected static final native void glGenerateMipmapEXT(int target);

    protected static final native boolean GL_EXT_framebuffer_object();

    // GL_EXT_texture_array ---------------------------------------------------------------------------------------------------

    protected static final int GL_TEXTURE_2D_ARRAY_EXT = 0x8C1A;
    
    protected static final native void glFramebufferTextureLayerEXT(int target, int attachment, int texture, int level, int layer);

    protected static final native boolean GL_EXT_texture_array();

    // GL_EXT_texture_filter_anisotropic --------------------------------------------------------------------------------------

    protected static final int GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE;
    protected static final int GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF;

    protected static final native boolean GL_EXT_texture_filter_anisotropic();

    // GLU --------------------------------------------------------------------------------------------------------------------

    protected static final native void gluPerspective(double fovy, double aspect, double zNear, double zFar);
    protected static final native void gluLookAt(double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ, double upX, double upY, double upZ);

    // ------------------------------------------------------------------------------------------------------------------------
}
