package joglni;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class OpenGLRenderer extends OpenGL
{
    // ------------------------------------------------------------------------------------------------------------------------

    static
    {
        System.loadLibrary("joglni");
    }

    // ------------------------------------------------------------------------------------------------------------------------

    protected final native void addError(String error);

    // ------------------------------------------------------------------------------------------------------------------------

    public abstract boolean init();
    public abstract void render(float frameTime);
    public abstract void resize(int width, int height);
    public abstract void destroy();

    // ------------------------------------------------------------------------------------------------------------------------

    protected static final byte[] getByteArray(short[] shortArray)
    {
        byte[] byteArray = new byte[shortArray.length * 2];

        ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asShortBuffer().put(shortArray);

        return byteArray;
    }

    protected static final byte[] getByteArray(int[] intArray)
    {
        byte[] byteArray = new byte[intArray.length * 4];

        ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asIntBuffer().put(intArray);

        return byteArray;
    }

    protected static final byte[] getByteArray(float[] floatArray)
    {
        byte[] byteArray = new byte[floatArray.length * 4];

        ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asFloatBuffer().put(floatArray);

        return byteArray;
    }

    protected static final byte[] getByteArray(double[] doubleArray)
    {
        byte[] byteArray = new byte[doubleArray.length * 8];

        ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asDoubleBuffer().put(doubleArray);

        return byteArray;
    }

    // ------------------------------------------------------------------------------------------------------------------------
}
