#include <afxwin.h>

#include <gl/glew.h> // http://glew.sourceforge.net/
#include <gl/wglew.h>

// ----------------------------------------------------------------------------------------------------------------------------

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glew32.lib")

// ----------------------------------------------------------------------------------------------------------------------------

extern CString ErrorLog;

// ----------------------------------------------------------------------------------------------------------------------------

class COpenGLRenderer
{
protected:
	int Width, Height;

public:
	COpenGLRenderer();
	~COpenGLRenderer();

	bool Init();
	void Render(float FrameTime);
	void Resize(int Width, int Height);
	void Destroy();
};

// ----------------------------------------------------------------------------------------------------------------------------

class CMyWnd : public CWnd
{
protected:
	CString Title;
	HGLRC hGLRC;
	int Width, Height;

public:
	CMyWnd();
	~CMyWnd();

	void Show(bool Maximized = false);

DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
};

// ----------------------------------------------------------------------------------------------------------------------------

class CMyWinApp : public CWinApp
{
public:
	CMyWinApp();
	~CMyWinApp();

	virtual BOOL InitInstance();
};
