#version 120

uniform sampler2D HeightMapTexture;

uniform float MaxHeightD2;

void main()
{
	float Height = texture2D(HeightMapTexture, gl_TexCoord[0].st).y;

	vec3 Color;
	
	if(Height < 0.0)
	{
		Color = vec3(0.5, 0.75f, 1.0f);
	}
	else if(Height >= 0.0 && Height < MaxHeightD2)
	{
		Color = mix(vec3(0.5, 1.0, 0.25), vec3(1.0, 0.5, 0.25), Height / MaxHeightD2);
	}
	else if(Height >= MaxHeightD2)
	{
		Color = mix(vec3(1.0, 0.5, 0.25), vec3(1.0, 1.0, 1.0), Height / MaxHeightD2 - 1.0);
	}

	gl_FragColor = vec4(Color, 1.0);
}
