#version 330

uniform sampler2D Texture;
uniform vec3 ViewSpaceLightPosition;
uniform mat4x4 ProjectionBiasMatrixInverse;

in vec2 TexCoord;
in vec3 ViewSpaceNormal, ViewSpacePosition;
in vec4 ClipSpacePosition;

out vec4 frag_Color;

void main()
{
	frag_Color = texture(Texture, TexCoord);
	
	vec4 TextureSpacePosition = ClipSpacePosition / ClipSpacePosition.w * 0.5 + 0.5;
	
	vec4 ViewSpacePosition = ProjectionBiasMatrixInverse * TextureSpacePosition;
	ViewSpacePosition /= ViewSpacePosition.w;
	
	vec3 ViewSpaceLightDirection = normalize(ViewSpaceLightPosition - ViewSpacePosition.xyz);
	
	float NdotLD = max(dot(normalize(ViewSpaceNormal), ViewSpaceLightDirection), 0.0);
	
	frag_Color.rgb *= NdotLD * 0.75 + 0.25;
	
	// frag_Color.rgb = ViewSpacePosition.xyz;
}
