#version 330

uniform mat3x3 NormalMatrix;
uniform mat4x4 ModelViewMatrix, ModelViewProjectionMatrix;

in vec2 vert_TexCoord;
in vec3 vert_Normal;
in vec4 vert_Position;

out vec2 TexCoord;
out vec3 ViewSpaceNormal, ViewSpacePosition;
out vec4 ClipSpacePosition;

void main()
{
	TexCoord = vert_TexCoord;
	ViewSpaceNormal = NormalMatrix * vert_Normal;
	ViewSpacePosition = (ModelViewMatrix * vert_Position).xyz;
	ClipSpacePosition = ModelViewProjectionMatrix * vert_Position;
	gl_Position = ClipSpacePosition;
}
